const mongoose = require('mongoose');

const customerSchema = new mongoose.Schema({
  name: {
    type: String,
    required: true
  },
  phone: {
    type: String,
    required: true,
    unique: true // Phone numbers should be unique for customers
  },
  email: {
    type: String,
    required: true,
    unique: true, // Emails should be unique for customers
    sparse: true // Allows multiple docs with null email
  },
  password: {
    type: String,
    required: true
  },
  resetPasswordToken: String,
  resetPasswordExpires: Date,
  createdAt: {
    type: Date,
    default: Date.now
  }

});

module.exports = mongoose.model('Customer', customerSchema);