// models/Labour.js
const mongoose = require('mongoose');

const labourSchema = new mongoose.Schema({
  name: String,
  phone: String,
  cnicPic: String,
  policeCertPic: String,
  address: String,
  password: String,
  resetPasswordToken: {
        type: String,
        default: undefined
    },
    resetPasswordExpires: {
        type: Date,
        default: undefined
    },
  email: String,
  labourType: [{
    type: String,
    enum: ['electrician', 'plumber', 'painter', 'carpenter', 'cleaner', 'mechanic', 'gardener'],
    required: true
  }],
  approved: { type: Boolean, default: false },
  location: {
    lat: Number,
    lng: Number
  },

  // New field to store pending work orders for the labourer
  pendingWorkOrders: [{
    type: mongoose.Schema.Types.ObjectId,
    ref: 'WorkOrder'
  }]
});

module.exports = mongoose.model('Labor', labourSchema);