const express = require('express');
const router = express.Router();
const adminController = require('../controllers/adminController');
// const { protect, admin } = require('../middleware/authMiddleware'); // Make sure your auth middleware is here

// Labourer approval routes
router.put('/approve-labour/:id', /* protect, admin, */ adminController.approveLabour);
router.delete('/reject-labour/:id', /* protect, admin, */ adminController.rejectLabour);

// Data fetching routes
router.get('/customers', /* protect, admin, */ adminController.getAllCustomers);
router.get('/labours', /* protect, admin, */ adminController.getAllLabours);
router.get('/work-orders', /* protect, admin, */ adminController.getAllWorkOrders);
router.get('/payments', /* protect, admin, */ adminController.getAllPayments);
router.get('/dashboard-stats', /* protect, admin, */ adminController.getDashboardStats);

// Payment status routes
router.put('/payments/:paymentId/status', /* protect, admin, */ adminController.updatePaymentStatus);
router.put('/payments/labourer/:labourerId/status', /* protect, admin, */ adminController.bulkUpdatePaymentStatus);


// ===============================================
// NEW: Routes for Admin to Manage Labour Types
// NOTE: These should be protected by your admin auth middleware.
// ===============================================

// Get all labour types (for the admin panel to display and manage them)
router.get('/labour-types-all', /* protect, admin, */ adminController.getAllLabourTypes);

// Create a new labour type
router.post('/labour-types', /* protect, admin, */ adminController.createLabourType);

// Delete a labour type by its ID
router.delete('/labour-types/:id', /* protect, admin, */ adminController.deleteLabourType);


module.exports = router;