// routes/customerRoutes.js
const express = require('express');
const router = express.Router();
const customerController = require('../controllers/customerController');
const authCustomer = require('../middleware/authCustomer');

router.post('/register', customerController.registerCustomer); // If you refactor registration here
router.post('/login', customerController.login);
// In your customer routes file
// ... your other routes like /login, /register ...
router.post('/forgot-password', customerController.forgotPassword);
router.post('/reset-password', customerController.resetPassword);


module.exports = router;